
(* 2x1 flyways w/ 1 xbots - short axis, 6 dof, 6 dof w speed *)
FUNCTION_BLOCK Example02_shortaxismotion
	(*move xbot 1 to 120,120*)
	PMC_XYMotion1(PM_Controller := PM_Controller,Execute := Execute,cmdLB := 1,XbotID := 1,Mode := 0,Type_ := 0,PosX := 0.12,PosY := 0.12,EndVel := 0,MaxVel := 1,MaxAcc := 10);

	(*short axis motion to z = 2 mm*)
	PMC_ShortAxisMotion1(PM_Controller := PM_Controller,Execute := PMC_XYMotion1.Done,cmdLB := 2,XbotID := 1,Mode := 0,Type_ := 0,PosZ := 0.002,PosRx := 0,PosRy := 0,PosRz := 0,VelZ := 0.1,VelRx := 0.1,VelRy := 0.1,VelRz := 0.1,Cx := 0,Cy := 0);

	(*short axis motion to z = 2 mm, rx = 10mrad, Ry = 10mrad, rz = 80mrad*)
	PMC_ShortAxisMotion2(PM_Controller := PM_Controller,Execute := PMC_ShortAxisMotion1.Done,cmdLB := 3,XbotID := 1,Mode := 0,Type_ := 0,PosZ := 0.002,PosRx := 0.01,PosRy := 0.01,PosRz := 0.08,VelZ := 0.1,VelRx := 0.1,VelRy := 0.1,VelRz := 0.5,Cx := 0,Cy := 0);

	(*short axis motion to z = 1 mm, rx = 0mrad, Ry = 0mrad, rz = 0mrad*)
	PMC_ShortAxisMotion3(PM_Controller := PM_Controller,Execute := PMC_ShortAxisMotion2.Done,cmdLB := 4,XbotID := 1,Mode := 0,Type_ := 0,PosZ := 0.001,PosRx := 0.0,PosRy := 0.0,PosRz := 0.0,VelZ := 0.1,VelRx := 0.1,VelRy := 0.1,VelRz := 0.5,Cx := 0.0,Cy := 0.0);

	(*six dof to x=80mm,y=100mm,z=2mm,rx=10mrad,ry=10mrad,rz=80mrad)*)
	PMC_6DMotion1(PM_Controller := PM_Controller,Execute := PMC_ShortAxisMotion3.Done,cmdLB := 5,XbotID := 1,PosX := 0.08,PosY := 0.1,PosZ := 0.002,PosRx := 0.01,PosRy := 0.01,PosRz := 0.08);

	(*six dof to (120,120,1,0,0,0) w/ user speeds*)
	Pos_array[0] := 0.12;Pos_array[1] := 0.12;Pos_array[2] := 0.001;
	LongAxisAccVel[0] := 0.1;LongAxisAccVel[1] := 0.1;
	ShortAxisVel[0] := 0.1;ShortAxisVel[1] := 0.1;ShortAxisVel[2] := 0.1;ShortAxisVel[3] := 0.1;
	PMC_6DMotionVelocity1(PM_Controller := PM_Controller,Execute := PMC_6DMotion1.Done,cmdLB := 6,XbotID := 1,TargetPos := Pos_array,LongAxisAccVel := LongAxisAccVel,ShortAxisVel := ShortAxisVel);

	Done := PMC_6DMotionVelocity1.Done;
END_FUNCTION_BLOCK
